<?php
declare(strict_types=1);

if (!defined('GRPG_INC')) {
    exit;
}


/**
 * @param string $name
 * @return string|null
 */
function read_secret(string $name): ?string
{
    $name = strtoupper($name);
    if ($val = getenv($name)) {
        return trim($val);
    }
    if ($val = getenv($name . '_FILE')) {
        return trim(file_get_contents($val));
    }
    return null;
}
if (!defined('INSTALLER') && empty(read_secret('DB_HOST'))) {
    header('Location: install');
    exit;
}
$extra_includes = getenv('EXTRA_INCLUDES');
if ($extra_includes !== false) {
    $files = explode(';', $extra_includes);
    if (count($files) > 0) {
        foreach ($files as $file) {
            if (file_exists($file)) {
                require_once $file;
            }
        }
    }
}
setlocale(LC_ALL, 'en_US');
$_SERVER['REMOTE_ADDR'] = array_key_exists('REMOTE_ADDR', $_SERVER) && filter_var($_SERVER['REMOTE_ADDR'],
    FILTER_VALIDATE_IP) ? $_SERVER['REMOTE_ADDR'] : '127.0.0.1';
define('BASE_URL', getenv('SITE_URL')); // Edit to suit your needs
define('BASE_PATH', getenv('GAME_PATH')); // Absolute path to base (example: /home/username/public_html)
define('DEBUG', (bool)getenv('DEBUG'));
/*
 *    Change the definitions below to match your setup
*/
const SESSION_NAME             = 'GRPG'; // Set to null to use default session name (generated by PHP). Set to custom string - refer to https://php.net/session_name for formats allowed
const GAME_NAME                = 'gRPG'; // Name your game!
const PRUNE_INACTIVE_ACCOUNTS  = false; // Boolean. Set to true to delete all accounts older than 30 days whenever control.php is accessed. Set to false or remove entirely to leave all accounts alone
const PAYPAL_ADDRESS           = ''; // Change to your own PayPal
const RMSTORE_CURRENCY         = 'USD'; // Edit to suit your needs - ISO 4217 codes are accepted
const RMSTORE_LOCALE           = 'en_US'; // Alter to match RMSTORE_CURRENCY's locale
const RMSTORE_DISCOUNT         = 0; // Percentage. Set to 0 to disable. Alter to set a discount on the RMStore Upgrades. Example: Setting to 10 will enable a 10% discount. Don't set to anything above 99 - breaks stuff otherwise
const RMSTORE_BOGOF            = false; // Set to true to enable "Boy One Get One Free" offer on RMStore Upgrades. Set to false to disable.
const MD5_COMPATIBILITY        = true; // Set to true to enable md5 passwords being accepted (if verified). Set to false to disable
const MD5_COMPAT_UPDATE        = true; // Set to true to enable updating md5 password to much stronger internal hashing (password_hash()) upon successful login. Set to false to disable. Requires MD5_COMPATIBILITY to be defined as true - a user changing their password will automatically use password_hash()
const CAPTCHA_REGISTRATION     = true; // Set to true to enable CAPTCHA on registration. Set to false to disable
const CAPTCHA_LOGIN            = false; // Set to true to enable CAPTCHA on login. Set to false to disable
const CAPTCHA_FORGOT_PASS      = true; // Set to true to enable CAPTCHA on forgotten password. Set to false to disable
const SQL_SESSIONS             = false; // Set to true to let the database handle PHP sessions. Set to false to use default disk file sessions
const SECURITY_TIMEOUT_MESSAGE = 'Your request has timed out for security purposes'; // In relation to CSRF protection. If a request is invalid, this message will be displayed
const DEFAULT_DATE_FORMAT      = 'F jS Y, g:i:sa'; // Match PHP's date() format
define('DEFAULT_EMAIL_ADDRESS', 'noreply@' . $_SERVER['HTTP_HOST']); // Ideally, you should alter this to a hard-coded email address, instead of relying on _SERVER['HTTP_HOST']
/*
 *     All definitions below MUST be called *before* including a core file
 *     Example:
 *     <?php
 *     define('NO_PDO', true);
 *     require_once _DIR__ . '/inc/example.php';
 *     // Rest of code...
*/
if (!defined('NO_SESSION')) { // If we haven't declared to not include the session handler
    require_once __DIR__ . '/Zebra_Session.php'; // Include the session handler
}
global $db;
require_once __DIR__ . '/pdo.class.php'; // Include the PDO function wrapper
if (!defined('NO_CSRF')) { // If we haven't declared to not include the CSRF protection file
    require_once __DIR__ . '/nocsrf.php'; // Include the CSRF protection file
}
require_once __DIR__ . '/classes/User.inc.php';
require_once __DIR__ . '/classes/User_Stats.inc.php';
if (!defined('NO_FUNCTIONS')) { // If we haven't declared to not include the functions file
    require_once __DIR__ . '/functions.php'; // Include the functions file
}
